<?php
$current_page = basename($_SERVER['SCRIPT_NAME'], '.php');

$pageLabel = match ($current_page) {
    'index'                            => 'Home',
    'about-us'                         => 'About Us',
    'thesis-publication'               => 'Thesis Publication',
    'dissertation-publication'         => 'Dissertation Publication',
    'article-publication'              => 'Article Publication',
    'book-publication'                 => 'Book Publication',
    'marketing'                        => 'Marketing',
    'peer-review'                      => 'Peer Review',
    'pre-submission-support'           => 'Pre-Submission Support',
    'book-editing-and-proofreading'    => 'Book Editing & Proofreading',
    'academic-editing-and-proofreading'=> 'Academic Editing & Proofreading',
    'contact-us'                       => 'Contact',
     default                           => ucwords(str_replace('-', ' ', $current_page)),
};

$titleText = "{$pageLabel} | Research Publications Experts";
?>

<head>
  <meta charset="UTF-8">
  <meta http-equiv="content-type" content="text/html;charset=UTF-8">


  <title><?= $titleText; ?></title>

  <meta name="description"
    content="An Award-winning Article Editing Services and Publishing Company in the UK acclaimed by Students and Professors. British Publications offers tailored editing/proofreading, formatting, and academic paper publishing services.">

  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">


  <link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.webp">
  <link rel="stylesheet" type="text/css" href="assets/css/style.css">
  <link rel="stylesheet" type="text/css" href="assets/css/style-web.css">
  <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">

  <link rel="stylesheet" href="../cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  <link rel="stylesheet" href="../cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
    integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
    crossorigin="anonymous" referrerpolicy="no-referrer" />

  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin="">
  <link
    href="css22e68.html?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
    rel="stylesheet">
</head>
