<?php
$content = require dirname(__DIR__) . '/constants/data.php';

$hero = $content[$current_page]['hero'] ?? $content['default']['hero'];

['subtitle' => $sub, 'title' => $title, 'text' => $text, 'img' => $img] = $hero;
$sectionId = $hero['id'] ?? '';
?>

<section <?= $sectionId ? 'id="' . htmlspecialchars($sectionId) . '" ' : '' ?> class="our-banner">
  <div class="container">
    <div class="row">
      <div class="col-md-7">
        <h3><?= htmlspecialchars($sub) ?></h3>
        <h1><?= htmlspecialchars($title) ?></h1>
        <p><?= htmlspecialchars($text) ?></p>
        <div class="row">
          <div class="col-md-12">
            <?php include 'includes/signUp.php'; ?>
          </div>
        </div>
      </div>
      <div class="col-md-5 Floating">
        <div class="hero__images4 text-center">
          <img src="<?= $img ?>" width="400" class="img-fluid img" alt="">
        </div>
      </div>
    </div>
  </div>
</section>
